/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MYear;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

@Process
public class YearCreatePeriods
extends SvrProcess {
    private int p_C_Year_ID = 0;
    private Timestamp p_StartDate;
    private String p_DateFormat;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("StartDate")) {
                    this.p_StartDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("DateFormat")) {
                    this.p_DateFormat = (String)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_Year_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MYear year = new MYear(this.getCtx(), this.p_C_Year_ID, this.get_TrxName());
        if (this.p_C_Year_ID == 0 || year.get_ID() != this.p_C_Year_ID) {
            throw new AdempiereUserError("@NotFound@: @C_Year_ID@ - " + this.p_C_Year_ID);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(year.toString());
        }
        if (year.createStdPeriods(null, this.p_StartDate, this.p_DateFormat)) {
            return "@OK@";
        }
        return "@Error@";
    }
}

